import { exhaustiveSwitchError } from "@tldraw/editor";
import { exportToBlobPromise, exportToString } from "./export.mjs";
function copyAs(editor, ids, format = "svg", opts = {}) {
  if (!window.navigator.clipboard) return Promise.reject(new Error("Copy not supported"));
  if (window.navigator.clipboard.write) {
    const { blobPromise, mimeType } = exportToBlobPromise(editor, ids, format, opts);
    return window.navigator.clipboard.write([new ClipboardItem({ [mimeType]: blobPromise })]).catch((err) => {
      console.error(err);
      return blobPromise.then((blob) => {
        return window.navigator.clipboard.write([new ClipboardItem({ [mimeType]: blob })]);
      });
    });
  }
  switch (format) {
    case "json":
    case "svg":
      return fallbackWriteTextAsync(async () => exportToString(editor, ids, format, opts));
    case "jpeg":
    case "png":
      throw new Error("Copy not supported");
    default:
      exhaustiveSwitchError(format);
  }
}
async function fallbackWriteTextAsync(getText) {
  await navigator.clipboard?.writeText?.(await getText());
}
export {
  copyAs
};
//# sourceMappingURL=copyAs.mjs.map
